#!/bin/bash
#SBATCH --time=20:00:00
#SBATCH --nodes=1
#SBATCH --ntasks=40
#SBATCH --ntasks-per-node=40

#make directory for fastq files
mkdir ./FASTQ

#copy fastq files into one directory
cat sampleInfo | while read read1 read2 parentsample nothing sampleID;
do
#change into sample dir
cd /scratch/cmp1g20/RMS_resistance_data/ZOES_DATA/RAW_DATA/"$sampleID"
#copy fastq files
cp *.fq.gz /scratch/cmp1g20/RMS_resistance_data/ZOES_DATA/FASTQ
cd ../
done

#fastqc.sh script

#Load fastqc programme
module load fastqc/0.11.9

#Make a new directory for the fastqc results
mkdir ./FASTQC/

#Run fastqc on all files in the FASTQ directory 
fastqc ./FASTQ/*.fq.gz -o FASTQC/
